<?php

namespace App\Http\Controllers\Accommodation;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accommodation\RatingHistoryResource;
use App\Http\Resources\RatingCollection;
use App\Http\Resources\RatingResource;
use App\sys\ApiResponse;
use App\sys\Services\Accommodation\RatingServices;
use Illuminate\Http\Request;

class RatingContoller extends Controller
{
    use ApiResponse;

    private $ratingService;

    private $ratingTranslationServices;

    public function __construct()
    {
        $this->ratingService = new RatingServices;
        $this->ratingTranslationServices = new \App\sys\Services\Accommodation\RatingTranslationServices;
    }

    public function create(Request $request)
    {
        if ($meal = $this->ratingService->add($request->all())) {
            $collect = new RatingResource($meal);

            return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
        }

        $errors = $this->ratingService->errors();

        return $this->apiResponse(400, 'Error creating meal plan', $errors, null);
    }

    public function update(Request $request)
    {
        if ($meal = $this->ratingService->update($request->all())) {
            $collect = new RatingResource($meal);

            return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
        }

        $errors = $this->ratingService->errors();

        return $this->apiResponse(400, 'Error creating meal plan', $errors, null);
    }

    public function index()
    {
        $data = $this->ratingService->get();
        $collect = new RatingCollection($data);

        return $this->apiResponse(200, 'Meal Plan created successfully', null, $collect);
    }

    public function getActive()
    {
        $data = $this->ratingService->getActive();
        $collect = new RatingCollection($data);

        return $this->apiResponse(200, 'Active Meal Plans retrieved successfully', null, $collect);
    }

    public function getByid($id = 0)
    {
        if ($data = $this->ratingService->getById($id)) {
            $collect = new RatingResource($data);

            return $this->apiResponse(200, 'Meal Plan retrieved successfully', null, $collect);
        }

        return $this->apiResponse(400, 'rating not found', ['rating not found'], null);
    }

    public function saveTranslation(Request $request, $id)
    {
        if (! $this->ratingTranslationServices->save($request->all(), $id)) {
            $errors = $this->ratingTranslationServices->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function getTranslation($id)
    {
        if ($data = $this->ratingService->getByidWithTranslation($id)) {
            $collection = new \App\Http\Resources\Accommodation\Rating\RatingLangResource($data);

            return $this->apiResponse(200, 'success', null, $collection);
        }
        $errors = $this->ratingService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function delLang($id)
    {
        if ($this->ratingTranslationServices->del($id)) {
            return $this->apiResponse(200, 'success', null, null);
        }

        $errors = $this->ratingTranslationServices->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function destroy(Request $request)
    {
        $ids = $request->input('ids', []);
        if (! is_array($ids) || empty($ids)) {
            return $this->apiResponse(400, 'No IDs provided for deletion', null, null);
        }
        $result = $this->ratingService->del($ids);
        if ($result) {
            return $this->apiResponse(200, 'Ratings deleted successfully', null, null);
        }
        $errors = $this->ratingService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);
    }

    public function getAllChanges($id)
    {
        $rating = $this->ratingService->getById($id);
        if (! $rating) {
            $errors = $this->ratingService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        $changes = $this->ratingService->getAllChanges($rating);

        return $this->apiResponse(200, 'success', null, RatingHistoryResource::collection($changes));
    }
}
