<?php

namespace App\Http\Controllers;

use App\Models\Airline;
use App\sys\ApiResponse;

class AirLinesControlers extends Controller
{
    use ApiResponse;

    public function search($code = null)
    {
        $air = Airline::when($code, function ($query, $code) {
            $query->Where(function ($query) use ($code) {
                $query->where('name_en', 'like', "%$code%")
                    ->orWhere('name_ar', 'like', "%$code%");
            });
        })->select('id', 'name_ar as name')->paginate();

        return $this->apiResponse(200, 'airline', null, $air);
    }
}
