<?php

namespace App\Http\Controllers\Profile;

use App\Http\Controllers\Controller;
use App\Http\Resources\Profile\AccommodationReservationPriceCollection;
use App\Http\Resources\Profile\AccommodationReservationPriceResource;
use App\sys\ApiResponse;
use App\sys\Services\Profile\AccommodationReservationPriceService;
use Illuminate\Http\Request;

class AccommodationReservationPriceController extends Controller
{
    use ApiResponse;

    protected AccommodationReservationPriceService $priceService;

    public function __construct(AccommodationReservationPriceService $priceService)
    {
        $this->priceService = $priceService;
    }

    public function index(Request $request)
    {
        $items = $this->priceService->getAll($request->all());

        return $this->apiResponse(200, 'success', null, new AccommodationReservationPriceCollection($items));
    }

    public function show(int $id)
    {
        $item = $this->priceService->getById($id);
        if (! $item) {
            $errors = $this->priceService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new AccommodationReservationPriceResource($item));
    }
}
