<?php

namespace App\Http\Controllers\Roles_Groups;

use App\Http\Controllers\Controller;
use App\Http\Resources\Roles_Groups\RoleCollection;
use App\Http\Resources\Roles_Groups\RolesResource;
use App\sys\ApiResponse;
use App\sys\Services\Roles_Groups\RoleService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class RoleController extends Controller
{
    use ApiResponse;

    protected $roleservice;

    public function __construct(RoleService $roleservice)
    {

        $this->roleservice = $roleservice;

    }

    public function index()
    {
        $constraints = $this->roleservice->getPaginated();

        return $this->apiResponse(200, 'success', null, new RoleCollection($constraints));
    }

    public function store(Request $request)
    {

        // Gate::authorize('create_role');

        $response = $this->roleservice->create($request->all());

        if (! $response) {
            $errors = $this->roleservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new RolesResource($response));

    }

    /**
     * Return a single role.
     */
    public function show($id)
    {

        $role = $this->roleservice->get($id);

        if (! $role) {
            $errors = $this->roleservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        // التعديل هنا:
        // شيلنا new RolesResource() لأن $role عبارة عن array جاهزة
        return $this->apiResponse(200, 'success', null, $role);
    }

    public function update(Request $request, $id)
    {
        $data = $request->all();
        $response = $this->roleservice->updatee($data, $id);
        if (! $response) {
            $errors = $this->roleservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new RolesResource($response));
    }

    public function delete($id)
    {
        if ($this->roleservice->deletee($id)) {
            return $this->apiResponse(200, 'Role deleted successfully', null, null);
        }

        return $this->apiResponse(400, 'Role not found', null, null);
    }

    public function getPermissions()
    {

        $permissions = config('global.permissions');

        return $this->apiResponse(200, 'Roles', null, $permissions);
    }

    public function destroy($id)
    {
        $response = $this->roleservice->deletee($id);
        if (! $response) {
            $errors = $this->roleservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', 'Roles deleted successfully', null);
    }

    public function updatePermissions(Request $request, $id)
    {
        $permissionIds = $request->input('permission_ids', []);

        $response = $this->roleservice->updatePermissions($id, $permissionIds);

        if (! $response) {
            $errors = $this->roleservice->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }
}
