<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckAnyAbility
{
    public function handle($request, Closure $next, ...$abilities)
    {
        $user = Auth::user();
        foreach ($abilities as $ability) {
            if ($user && $user->can($ability)) {
                return $next($request);
            }
        }

        abort(403, 'Unauthorized.');
    }
}
