<?php

namespace App\Http\Resources\Accommodation\RoomType;

use Illuminate\Http\Resources\Json\JsonResource;

class RoomTypeLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'active' => $this->is_active,
            'occupancy' => $this->occupancy,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? RoomTypeTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
