<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AreaResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'city_id' => $this->city_id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->name ?? $this->name)
                : $this->name,
            'city_name' => $this->city->name ?? null,
            'country_id' => $this->city->country->id ?? null,
            'country_name' => $this->city->country->name ?? null,
            'active' => $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
