<?php

namespace App\Http\Resources\General\Translation;

use Illuminate\Http\Resources\Json\JsonResource;

class TranslationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'language_id' => $this->language_id,
            'key' => $this->key,
            'controller_name' => $this->controller_name,
            'value' => $this->value,
            'is_translated' => $this->is_translated,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
