<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class RestaurantResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->name ?? $this->name)
                : $this->name,
            'description' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->description ?? $this->description)
                : $this->description,
            'google_map_link' => $this->google_map_link,
            'active' => $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
