<?php

namespace App\Models\Accommodation;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\App;

class MealPlans extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'ac_meal_plans';

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    public function translations()
    {
        return $this->hasMany(MealPlansTranslations::class, 'meal_plan_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(MealPlansTranslations::class, 'meal_plan_id')
            ->where('lang_id', app('lang_id'));
    }

    // protected $appends = ['name'];

    /*
    public function getNameAttribute()
    {
        return $this->{'name_'.App::getLocale()} == null ? $this->name_ar : $this->{'name_'.App::getLocale()};
    }
    */
}
