<?php

namespace App\Models\Accommodation;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RoomViews extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'ac_room_views';

    public function translations()
    {
        return $this->hasMany(RoomViewTranslations::class, 'room_view_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(RoomViewTranslations::class, 'room_view_id')
            ->where('lang_id', app('lang_id'));
    }
}
