<?php

namespace App\Models\Accounting;

use App\Models\General\Currency;
use App\Models\Profile\Customer;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transfer extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'sales_id',
        'creditor',
        'debit',
        'date',
        'tree_accounting_id',
        'cost_center_id',
        'type',
        'constraint_id',
        'debit_text',
        'creditor_text',
        'titles',
        'user_id',
        'capture_exchange',
        'profile_id',
        'supplier_id',
        'customer_id',
        'invoice_id',
        'note',
        'meeting_time',
        'pay_type_id',
        'currency_id',
        'currency_transfer_rate',
    ];

    public function constraint()
    {
        return $this->belongsTo(Constraint::class, 'constraint_id');
    }

    public function treeAccounting()
    {
        return $this->belongsTo(TreeAccounting::class, 'tree_accounting_id');
    }

    public function costCenter()
    {
        return $this->belongsTo(CostCenter::class, 'cost_center_id');
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id');
    }

    public function paytype()
    {
        return $this->belongsTo(Paytype::class, 'pay_type_id');
    }
}
