<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class GuideLanguage extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $table = 'guide_language';

    protected $fillable = [
        'name',
        'code',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected $auditInclude = [
        'name',
        'code',
        'is_active',
    ];

    protected $auditExclude = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $auditEvents = [
        'updated',
    ];

    public function translations()
    {
        return $this->hasMany(GuideLanguageTranslation::class, 'guide_language_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(GuideLanguageTranslation::class, 'guide_language_id')
            ->where('lang_id', app('lang_id'));
    }
}
