<?php

namespace App\Models\Suppliers;

use App\Models\Languages\Languages;
use Illuminate\Database\Eloquent\Model;

class SupplierTranslation extends Model
{
    protected $table = 'su_supplier_translation';

    protected $fillable = [
        'lang_id',
        'supplier_name',
        'supplier_address',
    ];

    public function getLang()
    {
        return $this->belongsTo(Languages::class, 'lang_id');
    }
}
