<?php

namespace App\sys\Services\Accommodation;

use App\sys\Repository\Accommodation\RatingRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class RatingServices extends Services
{
    private $rating;

    public function __construct()
    {
        $this->rating = new RatingRepository;
    }

    public function add($data)
    {
        $rules = [
            'name' => ['required', 'string', 'max:255'],
            'active' => ['required', 'in:0,1'],
        ];

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        $rating = $this->rating->add($data);
        $this->syncTranslations($rating);

        return $rating;
    }

    public function update($data)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_room_types,id'],
            'name' => ['sometimes', 'string', 'max:255'],
            'active' => ['sometimes', 'in:0,1'],
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->rating->updated($data);
    }

    public function get()
    {
        return $this->rating->get();
    }

    public function getByid($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_room_types,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError('Not Found');

            return false;
        }

        return $this->rating->getById($id);
    }

    public function getActive()
    {
        return $this->rating->getActive();
    }

    public function getByidWithTranslation($id)
    {
        $rules = [
            'id' => ['required', 'integer', 'exists:ac_rating,id'],
        ];
        $validator = Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $rating = $this->rating->getByIdWithTranslation($id);

        return $this->syncTranslations($rating, true);
    }

    public function del(array $ids)
    {
        return $this->rating->del($ids);
    }

    public function getAllChanges($rating)
    {
        return $this->rating->getAllChanges($rating);
    }
}
