<?php

namespace App\sys\Services\Languages;

use App\sys\Repository\Languages\LanguagesRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class LagnuagesServices extends Services
{
    private $lang;

    public function __construct(LanguagesRepository $lang)
    {
        $this->lang = $lang;
    }

    public function add($data)
    {
        $rules = [
            'name' => 'required|string|max:255|unique:languages,name',
            'code' => 'required|string|max:10|unique:languages,code',
            'active' => 'required|in:0,1',
            'rtl' => 'required|in:0,1',
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->lang->add($data);
    }

    public function updated($data)
    {
        $rules = [
            'id' => 'required|integer|exists:languages,id',
            'name' => 'sometimes|string|max:255|unique:languages,name,'.$data['id'],
            'code' => 'sometimes|string|max:10|unique:languages,code,'.$data['id'],
            'active' => 'sometimes|in:0,1',
            'rtl' => 'sometimes|in:0,1',
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->lang->updated($data);
    }

    public function get()
    {
        return $this->lang->gets();
    }

    public function getActive()
    {
        return $this->lang->getActive();
    }

    public function getByid($id)
    {
        return $this->lang->getById($id);
    }
}
