<?php

namespace App\sys\Services\Roles_Groups;

use App\sys\Repository\Roles_Groups\GroupRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class GroupService extends Services
{
    protected $grouprepo;

    public function __construct(GroupRepository $grouprepo)
    {
        $this->grouprepo = $grouprepo;
    }

    public function getPaginated()
    {
        return $this->grouprepo->getPaginated();
    }

    public function deletee($id)
    {
        return $this->grouprepo->deletee($id);
    }

    public function get($id)
    {
        $validator = Validator::make(['id' => $id], [
            'id' => ['required', 'integer', 'exists:groups,id'],
        ]);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $group = $this->grouprepo->find($id);

        return $group;
    }
}
