<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\Http\Resources\Accounting\InvoiceCollection;
use App\Http\Resources\Accounting\InvoiceResource;
use App\sys\ApiResponse;
use App\sys\Services\Accounting\InvoiceService;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    use ApiResponse;

    protected InvoiceService $service;

    public function __construct(InvoiceService $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        $invoices = $this->service->getPaginated();

        return $this->apiResponse(200, 'success', null, new InvoiceCollection($invoices));
    }

    public function show($id)
    {
        $item = $this->service->getById((int) $id);
        if (! $item) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new InvoiceResource($item));
    }

    public function getByProfile($profileId)
    {
        $items = $this->service->getByProfileId((int) $profileId);
        if ($items === false) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, InvoiceResource::collection($items));
    }

    public function getByNextDate(Request $request)
    {
        $nextDate = $request->input('next_date');
        if (! $nextDate) {
            return $this->apiResponse(400, 'fail', ['next_date' => ['next_date is required']], null);
        }

        $items = $this->service->getByNextDate($nextDate);
        if ($items === false) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, InvoiceResource::collection($items));
    }

    public function store(Request $request)
    {
        $response = $this->service->create($request->all());
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new InvoiceResource($response));
    }

    public function update(Request $request)
    {
        $response = $this->service->update($request->all());
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new InvoiceResource($response));
    }

    public function destroy(Request $request)
    {
        $response = $this->service->del($request->ids);
        if (! $response) {
            $errors = $this->service->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', 'Invoice deleted successfully', null);
    }
}
