<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Resources\User\UserResource;
use App\sys\ApiResponse;
use App\sys\Services\Auth\AuthService;
use Illuminate\Http\Request;

class AuthController extends Controller
{
    use ApiResponse;

    protected $authservice;

    public function __construct(AuthService $authservice)
    {
        $this->authservice = $authservice;
    }

    public function Login(Request $request)
    {
        $result = $this->authservice->login($request->only('email', 'password'));

        if (! $result) {
            $errors = $this->authservice->errors();

            return $this->apiResponse(401, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, [
            'token' => 'Bearer '.$result['token'],
            'token_type' => 'Bearer',
            'expires_in' => config('jwt.ttl') * 60,
            'data' => new UserResource($result['user']),
        ]);
    }

    public function logout()
    {
        $result = $this->authservice->logout();

        if (! $result) {
            $errors = $this->authservice->errors();

            return $this->apiResponse(500, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, null);
    }

    public function refresh()
    {
        $tokenData = $this->authservice->refreshToken();

        if (! $tokenData) {
            $errors = $this->authservice->errors();

            return $this->apiResponse(500, 'fail', $errors, null);

        }

        // رجع التوكن الجديد بنفس شكل الـ format
        return $this->apiResponse(200, 'success', null, $tokenData);
    }

    public function changePassword(Request $request)
    {
        $data = $request->only(
            'old_password',
            'new_password',
            'new_password_confirmation'
        );

        $success = $this->authservice->changePassword($data);

        if (! $success) {
            $errors = $this->authservice->errors();

            return $this->apiResponse(500, 'fail', $errors, null);

        }

        return $this->apiResponse(200, 'success', null, null);

    }

    public function me()
    {

        $user = auth('api')->user();

        $user->load(
            'role', 'groups', 'services', 'accommodations', 'companies',
            'account_mappings.currency',
            'account_mappings.commissionAccount',
            'account_mappings.walletAccount'
        );

        return $this->apiResponse(200, 'success', null, new UserResource($user));

    }
}
