<?php

namespace App\Http\Controllers\General\Translation;

use App\Http\Controllers\Controller;
use App\Http\Resources\General\Translation\TranslationCollection;
use App\sys\ApiResponse;
use App\sys\Services\General\Translation\TranslationService;
use Illuminate\Http\Request;

class TranslationController extends Controller
{
    use ApiResponse;

    protected $translationService;

    public function __construct(TranslationService $translationService)
    {
        $this->translationService = $translationService;
    }

    public function index($language_id)
    {

        $translations = $this->translationService->getPaginated($language_id);

        return $this->apiResponse(200, 'success', null, new TranslationCollection($translations));
    }

    public function getControllerNames()
    {
        $names = $this->translationService->getControllerNames();

        return $this->apiResponse(200, 'success', null, $names);
    }

    public function bulkUpdate(Request $request)
    {
        $data = $request->all();
        if ($this->translationService->updateBatch($data)) {
            return $this->apiResponse(200, 'translations updated successfully', null, null);
        }

        return $this->apiResponse(400, 'Error updating translations', $this->translationService->errors(), null);
    }

    public function getLang($id)
    {
        if (file_exists(public_path().'/lang/'.$id.'.json')) {
            $data = file_get_contents(public_path().'/lang/'.$id.'.json');

            return json_decode($data);

            return $this->apiResponse(200, 'success', null, json_decode($data));
        }

        return [];

        return $this->apiResponse(400, 'Translation not found', ['File Not Found!'], null);
    }
}
