<?php

namespace App\Http\Controllers\Profile;

use App\Http\Controllers\Controller;
use App\Http\Resources\Profile\ProfileCollection;
use App\Http\Resources\Profile\ProfileColumnHistoryResource;
use App\Http\Resources\Profile\ProfileHistoryResource;
use App\Http\Resources\Profile\ProfileResource;
use App\sys\ApiResponse;
use App\sys\Services\Accounting\UnpostedCollectionsServices;
use App\sys\Services\Profile\ProfileService;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    use ApiResponse;

    protected ProfileService $profileService;

    public function __construct(ProfileService $profileService)
    {
        $this->profileService = $profileService;

    }

    public function index()
    {
        $items = $this->profileService->getPaginated();

        return $this->apiResponse(200, 'success', null, new ProfileCollection($items));
    }

    public function show($id)
    {
        $item = $this->profileService->getById($id);
        if (! $item) {
            $errors = $this->profileService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }
        $resource = (new ProfileResource($item))->includeChanges();

        return $this->apiResponse(200, 'success', null, $resource);
    }

    public function store(Request $request)
    {
        $response = $this->profileService->create($request->all());
        if (! $response) {
            $errors = $this->profileService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, new ProfileResource($response));
    }

    public function update(Request $request)
    {
        $response = $this->profileService->update($request->all());
        if (! $response) {
            $errors = $this->profileService->errors();

            return $this->apiResponse(400, 'fail', null, $errors);
        }

        return $this->apiResponse(200, 'success', null, new ProfileResource($response));
    }

    public function destroy(Request $request)
    {
        $response = $this->profileService->del($request->ids);
        if (! $response) {
            $errors = $this->profileService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', 'Profile deleted successfully', null);
    }

    public function getActive()
    {
        $items = $this->profileService->getActive();

        return $this->apiResponse(200, 'success', null, new ProfileCollection($items));
    }

    public function getAllChanges($id)
    {
        $allChanges = $this->profileService->getAllChanges($id);
        if (! $allChanges) {
            $errors = $this->profileService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, ProfileHistoryResource::collection($allChanges));
    }

    public function getColumChanges($id, $columnName)
    {
        $columnHistory = $this->profileService->getColumnChanges($id, $columnName);
        if (! $columnHistory) {
            $errors = $this->profileService->errors();

            return $this->apiResponse(400, 'fail', $errors, null);
        }

        return $this->apiResponse(200, 'success', null, ProfileColumnHistoryResource::collection($columnHistory));
    }

    public function checkReservation($id)
    {
        $data = $this->profileService->checkReservations($id);

        return $this->apiResponse(200, 'success', null, $data);

    }

    public function getProfileShare($code = 0)
    {
        if ($data = $this->profileService->getProfileShare($code)) {
            return $this->apiResponse(200, 'success', null, $data);
        }

        $errors = $this->profileService->errors();

        return $this->apiResponse(400, 'fail', $errors, null);

    }

    public function invoiceProfile($id)
    {
        $accountingService = new UnpostedCollectionsServices;
        $invoice = $accountingService->createInvoiceWithoutPayment((int) $id);

        if (! $invoice) {
            return $this->apiResponse(400, 'fail', $accountingService->errors(), null);
        }

        return $this->apiResponse(200, 'success', null, $invoice);
    }

    public function customerProfiles($id) {}
}
