<?php

namespace App\Http\Middleware;

use App\Sys\ApiResponse;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureAuthenticated
{
    use ApiResponse;

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (! auth()->guard('api')->check()) {
            return $this->apiResponse(403, 'error', ['Unauthorized. Please log in.'], null);
        }

        return $next($request);
    }
}
