<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class CostCenterResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id ?? null,
            'name' => $this->name ?? null,
            'number' => $this->number ?? null,
            'full_number' => $this->full_number ?? null,
            'cost_center_id' => $this->cost_center_id ?? null,
            'parent_name' => $this->parent->name ?? null,
            'parent_full_number' => $this->parent->full_number ?? null,
            // children tree (used by all endpoint)
            'children' => $this->whenLoaded('getAllChildren', function () {
                return self::collection($this->getAllChildren);
            }),
            'created_at' => $this->created_at ?? null,
            'updated_at' => $this->updated_at ?? null,
        ];
    }
}
