<?php

namespace App\Http\Resources\Accounting;

use Illuminate\Http\Resources\Json\JsonResource;

class InvoiceResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'serial_num' => $this->serial_num,
            'profile_num' => $this->profile->profile_number,
            'profile_id' => $this->profile_id,
            'customer_id' => $this->customer_id,
            'company_id' => $this->company_id,
            'invoice_date' => $this->invoice_date,
            'recip_date' => $this->recip_date,
            'pay_duration' => $this->pay_duration,
            'invoice_date_due' => $this->invoice_date_due,
            'invoice_price' => $this->invoice_price,
            'invoice_type' => $this->invoice_type,
            'paid_price' => $this->paid_price,
            'paid_date' => $this->paid_date,
            'remaining_price' => $this->remaining_price,
            'worthy_days' => $this->worthy_days,
            'notes' => $this->notes,
            'conditions' => $this->conditions,
            'next_paid_date' => $this->next_paid_date,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
