<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CurrencyResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->name ?? $this->name)
                : $this->name,
            'code' => $this->code,
            'symbol' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->symbol ?? $this->symbol)
                : $this->symbol,
            'exchange_rate' => $this->exchange_rate,
            'active' => $this->status,
            'is_default' => $this->is_default,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
        ];
    }
}
