<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class LanguageResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'code' => $this->code,
            'image' => asset('/images/flags/'.$this->code.'.png'),
            'active' => $this->is_active,
            'rtl' => $this->rtl,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
        ];
    }
}
