<?php

namespace App\Http\Resources\Profile;

use Illuminate\Http\Resources\Json\JsonResource;

class DailyProgramsResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'profile_id' => $this->profile_id,
            'day_number' => $this->day_number,
            'day_date' => $this->day_date,
            'services_count' => $this->when(isset($this->invoice_services_count), (int) $this->invoice_services_count),
            'has_services' => $this->when(isset($this->invoice_services_count), (bool) ($this->invoice_services_count > 0)),
            'handling_services_count' => $this->when(isset($this->handling_services_count), (int) $this->handling_services_count),
            'handling_services_titles' => $this->when($this->relationLoaded('invoiceServices'), function () {
                return $this->invoiceServices
                    ->map(function ($service) {
                        return optional(optional($service->service)->currentTranslation)->title;
                    })
                    ->filter()
                    ->values()
                    ->all();
            }),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
