<?php

namespace App\Http\Resources\Profile;

use App\sys\Helper;
use Illuminate\Http\Resources\Json\JsonResource;

class ProfileResource extends JsonResource
{
    protected bool $includeChanges = false;

    public function includeChanges(): self
    {
        $this->includeChanges = true;

        return $this;
    }

    protected function getColumnDisplayMapping()
    {
        return [
            'is_active' => 'active',
            'customer_id' => 'customer',
            'company_id' => 'company',
            'user_id' => 'user',

        ];
    }

    protected function transformChanges(array $changes)
    {
        $mapping = $this->getColumnDisplayMapping();
        $transformedChanges = [];

        foreach ($changes as $columnName) {
            $displayName = $mapping[$columnName] ?? $columnName;
            $transformedChanges[$displayName] = $columnName;
        }

        return $transformedChanges;
    }

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'profile_number' => $this->profile_number,
            'company_id' => $this->company_id,
            'user_id' => $this->user_id,
            'customer_id' => $this->customer_id,
            'children_count' => $this->children_count,
            'children_no_fee_count' => $this->children_no_fee_count,
            'adults_count' => $this->adults_count,
            'arrival_airline' => $this->arrival_airline,
            'arrival_airline_name' => $this->airlineArrival->name_en,
            'arrival_flight_number' => $this->arrival_flight_number,
            'departure_airline' => $this->departure_airline,
            'departure_airline_name' => $this->airlineDeparture->name_en,
            'departure_flight_number' => $this->departure_flight_number,
            'arrival_date' => $this->arrival_date ? $this->arrival_date->format('Y-m-d') : null,
            'arrival_time' => $this->arrival_time ? $this->arrival_time->format('H:i') : null,
            'departure_date' => $this->departure_date ? $this->departure_date->format('Y-m-d') : null,
            'departure_time' => $this->departure_time ? $this->departure_time->format('H:i') : null,
            'trip_duration_days' => $this->trip_duration_days,
            'status' => $this->status,
            'has_invoice' => (bool) ($this->has_invoice ?? false),
            'link_code' => $this->link_code,
            'customer_notes' => $this->customer_notes,
            'employee_notes' => $this->employee_notes,
            'active' => (bool) $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'customer' => $this->when($this->relationLoaded('customer'), function () {
                return $this->customer ? new CustomerResource($this->customer) : null;
            }),
            'company' => $this->when($this->relationLoaded('company'), function () {
                return $this->company ? [
                    'id' => $this->company->id,
                    'name' => $this->company->name_company,
                ] : null;
            }),
            'user' => $this->when($this->relationLoaded('user'), function () {
                return $this->user ? [
                    'id' => $this->user->id,
                    'name' => $this->user->name,
                ] : null;
            }),
            ...($this->includeChanges ? [
                'changes' => $this->transformChanges(Helper::getChangedColumns($this->resource)->toArray()),
            ] : []),
        ];
    }
}
