<?php

namespace App\Http\Resources\Roles_Groups;

use Illuminate\Http\Resources\Json\ResourceCollection;

class RoleCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $response = [
            'data' => RolesResource::collection($this->collection),
        ];

        // Check if the resource is paginated
        if ($this->resource instanceof \Illuminate\Pagination\AbstractPaginator) {
            $response['links'] = $this->paginationLinks();
            $response['meta'] = [
                'pagination' => [
                    'total' => $this->total(),
                    'count' => $this->count(),
                    'per_page' => $this->perPage(),
                    'current_page' => $this->currentPage(),
                    'total_pages' => $this->lastPage(),
                ],
            ];
        }

        return $response;
    }

    /**
     * Get the pagination links for the response.
     *
     * @return string|null
     */
    protected function paginationLinks()
    {
        $paginator = $this->resource;
        $nextPage = $paginator->currentPage() + 1;

        // Return the URL for the next page, or null if it's the last page
        $links = $nextPage <= $paginator->lastPage() ? $paginator->url($nextPage) : null;

        return $links;
    }
}
