<?php

namespace App\Http\Resources\Suppliers;

use Illuminate\Http\Resources\Json\JsonResource;

class SupplierTranslationResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'supplier_id' => $this->supplier_id,
            'lang_id' => $this->lang_id,
            'supplier_name' => $this->supplier_name,
            'supplier_address' => $this->supplier_address,
            'lang_name' => $this->getLang->name ?? null,
            'lang_code' => $this->getLang->code ?? null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
