<?php

namespace App\Models\Accommodation;

use App\Models\Accounting\TreeAccounting;
use App\Models\General\Currency;
use Illuminate\Database\Eloquent\Model;

class AccommodationsCurrencies extends Model
{
    protected $table = 'ac_accommodations_currencies';

    protected $fillable = [
        'accommodation_id',
        'currency_id',
        'tree_accounting_id',
        'tree_income_accounting_id',
    ];

    public function accommodation()
    {
        return $this->belongsTo(Accommodations::class, 'accommodation_id');
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function treeAccounting()
    {
        return $this->belongsTo(TreeAccounting::class, 'tree_accounting_id', 'tree_accounting_id');
    }

    public function treeIncomeAccounting()
    {
        return $this->belongsTo(TreeAccounting::class, 'tree_income_accounting_id', 'tree_accounting_id');
    }
}
