<?php

namespace App\Models\Accommodation;

use App\Models\Languages\Languages;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccommodationsTranslations extends Model
{
    use HasFactory;

    protected $table = 'ac_accommodations_translation';

    protected $fillable = [
        'lang_id',
        'name',
        'description',
    ];

    public function getLang()
    {
        return $this->belongsTo(Languages::class, 'lang_id');
    }
}
