<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Model;

class PaytypeTranslation extends Model
{
    protected $table = 'pay_type_translation';

    protected $fillable = [
        'pay_type_id',
        'lang_id',
        'title',
    ];

    public function paytype()
    {
        return $this->belongsTo(Paytype::class, 'pay_type_id');
    }

    public function getLang()
    {
        return $this->belongsTo(\App\Models\Languages\Languages::class, 'lang_id');
    }
}
