<?php

namespace App\Models\Profile;

use App\Models\General\TaxRate;
use Illuminate\Database\Eloquent\Model;

class ProfileTravelerTax extends Model
{
    protected $table = 'pr_profile_travelers_tax';

    protected $fillable = [
        'profile_id',
        'profile_travelers_id',
        'tax_rate_id',
        'amount',
    ];

    public function tax()
    {
        return $this->belongsTo(TaxRate::class, 'tax_rate_id');
    }
}
