<?php

namespace App\sys\Repository\General\Translation;

use App\Models\General\LanguageTranslation;

class TranslationRepository
{
    protected $model;

    public function __construct(LanguageTranslation $model)
    {
        $this->model = $model;
    }

    public function getPaginated($language_id)
    {
        $controller_name = request('controller_name', null);
        $key = request('key', null);
        $value = request('value', null);

        return $this->model::where('language_id', $language_id)
            ->when($controller_name, function ($query) use ($controller_name) {
                $query->where('controller_name', $controller_name);
            })->when($key, function ($query) use ($key) {
                $query->where('controller_name', $key);
            })->when($value, function ($query) use ($value) {
                $query->where('value', $value);
            })->orderBy('controller_name')->get();

    }

    public function getUniqueControllerNames()
    {
        return $this->model::distinct()->pluck('controller_name');
    }

    public function updateBatch($data)
    {
        $updatedCount = 0;
        foreach ($data as $item) {
            if (isset($item['translation_id']) && isset($item['value']) && isset($item['language_id'])) {
                $record = $this->model->where('id', $item['translation_id'])
                    ->where('language_id', $item['language_id'])
                    ->first();
                if ($record) {
                    $record->update([
                        'value' => $item['value'],
                        'is_translated' => 1,
                    ]);
                    $updatedCount++;
                }
            }
        }

        return $updatedCount;
    }
}
