<?php

namespace App\sys\Repository\Roles_Groups;

use App\Models\Permission;

class PermissionRepositery
{
    protected $permissionmodel;

    public function __construct(Permission $permissionmodel)
    {
        $this->permissionmodel = $permissionmodel;
    }

    protected $columns = [
        'id' => 'id',
        'permission_name' => 'permission_name',
        'created_at' => 'created_at',
        'collection_name' => 'collection_name',
    ];

    public function getPaginated()
    {

        $column = request('sort_by', null);
        $order = request('sort_order', 'desc');
        $permission_name = request('permission_name', null);
        $limit = request('limit', 15);

        $query = Permission::query()
            ->when($permission_name, function ($q, $permission_name) {
                // البحث بالاسم
                $q->where('permission-name', 'LIKE', "%$permission_name%");
            })
            ->when(request('collection_name'), function ($q, $collection_name) {
                $q->where('collection_name', 'LIKE', "%$collection_name%");
            });

        if ($column && array_key_exists($column, $this->columns)) {
            $query->orderBy($this->columns[$column], $order);
        } else {

            $query->orderBy('created_at', $order);
        }

        return $query->paginate($limit);
    }

    public function add($data)
    {
        return $this->permissionmodel->create([
            'permission_name' => $data['permission_name'],
            'Controller_name' => $data['Controller_name'] ?? null,
            'collection_name' => $data['collection_name'] ?? null,
        ]);
    }

    public function updated($id, $data)
    {
        $permission = $this->permissionmodel->find($id);

        if (! $permission) {
            return false;
        }

        // $this->clearCacheForAffectedUsers($permission);

        if (array_key_exists('permission_name', $data)) {
            $permission->name = $data['permission_name'];
        }

        if (array_key_exists('Controller_name', $data)) {
            $permission->name = $data['Controller_name'];
        }

        if (array_key_exists('collection_name', $data)) {
            $permission->collection_name = $data['collection_name'];
        }

        $permission->save();

        return $permission;
    }

    public function deletee($id)
    {

        $permission = $this->permissionmodel->find($id);

        if (! $permission) {
            return false;
        }

        // $this->clearCacheForAffectedUsers($permission);

        return $permission->delete();
    }

    public function find($id)
    {
        return $this->permissionmodel->find($id);
    }

    // protected function clearCacheForAffectedUsers($permission)
    //     {
    //         $usersWithOverride = $permission->usersWithOverrides()->get();

    //         $usersWithRole = collect();
    //         $permission->roles()->with('users')->get()->each(function ($role) use (&$usersWithRole) {
    //             $usersWithRole = $usersWithRole->merge($role->users);
    //         });

    //         $allAffectedUsers = $usersWithOverride->merge($usersWithRole)->unique('id');

    //         $allAffectedUsers->each(function ($user) {
    //             $user->clearPermissionCache();
    //         });
    //     }

}
