<?php

namespace App\sys\Repository\Suppliers;

use App\Models\Suppliers\SupplierTranslation;

class SupplierTranslationRepository
{
    private SupplierTranslation $supplierTranslation;

    public function __construct()
    {
        $this->supplierTranslation = new SupplierTranslation;
    }

    public function save(array $data, int $supplierId): bool
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] !== null) {
                $this->update($value);
            } else {
                $this->add($value, $supplierId);
            }
        }

        return true;
    }

    public function add(array $data, int $supplierId): void
    {
        $translation = new SupplierTranslation;
        $translation->supplier_id = $supplierId;
        $translation->lang_id = $data['language_id'];
        $translation->supplier_name = $data['supplier_name'] ?? null;
        $translation->supplier_address = $data['supplier_address'] ?? null;
        $translation->save();
    }

    public function update(array $data): void
    {
        $translation = $this->supplierTranslation->find($data['id']);
        if ($translation) {
            $translation->supplier_name = $data['supplier_name'] ?? $translation->supplier_name;
            $translation->supplier_address = $data['supplier_address'] ?? $translation->supplier_address;
            $translation->save();
        }
    }

    public function get(int $supplierId)
    {
        return $this->supplierTranslation->with('getLang')->where('supplier_id', $supplierId)->get();
    }

    public function del(int $id): bool
    {
        $translation = $this->supplierTranslation->find($id);
        if ($translation) {
            return (bool) $translation->delete();
        }

        return false;
    }
}
