<?php

namespace App\sys\Services\Auth;

use App\sys\Repository\Auth\AuthRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class AuthService extends Services
{
    protected $authrepo;

    public function __construct(AuthRepository $authrepo)
    {
        $this->authrepo = $authrepo;
    }

    public function login(array $data)
    {
        $rules = [
            'email' => 'required|email',
            'password' => 'required|string',
        ];

        $validator = Validator::make($data, $rules);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        $credentials = [
            'email' => $data['email'],
            'password' => $data['password'],
        ];

        // ✅ JWT Attempt
        if (! $token = auth('api')->attempt($credentials)) {
            $this->setError(['email' => ['Invalid credentials.']]);

            return false;
        }

        $user = auth('api')->user();

        if (! $user->is_active) {
            $this->setError(['email' => ['This account is inactive.']]);

            return false;
        }

        $user->load(
            'role',
            'groups',
            'services',
            'accommodations',
            'companies',
            'account_mappings.currency',
            'account_mappings.commissionAccount',
            'account_mappings.walletAccount'
        );

        return [
            'user' => $user,
            'token' => $token,
        ];
    }

    public function logout()
    {
        auth('api')->logout();

        return true;
    }

    // Method For Refersh Token
    public function refreshToken()
    {
        $token = auth()->guard('api')->refresh();

        return [
            'token' => 'Bearer '.$token,
        ];
    }

    public function changePassword(array $data)
    {
        // 1. التحقق من المدخلات (Validation)
        $validator = Validator::make($data, [
            'old_password' => 'required|string',
            'new_password' => 'required|string|min:8|confirmed',
        ]);

        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $user = auth('api')->user();

        $data = $this->authrepo->changePassword($user, $data);

        auth('api')->logout();

        return $data;
    }
}
