<?php

namespace App\sys\Services\General;

use App\sys\Repository\General\NationalityTranslationRepository;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class NationalityTranslationService extends Services
{
    private $nationalityTranslation;

    public function __construct()
    {
        $this->nationalityTranslation = new NationalityTranslationRepository;
    }

    public function save(array $data, $id)
    {
        $rules = ['nationality_id' => 'required|integer|exists:nationalities,id'];
        $combinations = [];
        $customErrors = [];
        foreach ($data as $index => $row) {
            $rowId = $row['id'] ?? null;
            $languageId = $row['language_id'] ?? null;
            $rules["$index.id"] = 'sometimes|nullable|exists:nationality_translation,id';
            $rules["$index.language_id"] = [
                Rule::requiredIf(empty($rowId)),
                'exists:languages,id',
                Rule::unique('nationality_translation', 'lang_id')
                    ->where(fn ($query) => $query->where('nationality_id', $id))
                    ->ignore($rowId),
            ];
            $rules["$index.name"] = 'nullable|string|max:300';
            if ($languageId) {
                $key = $id.'-'.$languageId;
                if (in_array($key, $combinations)) {
                    $customErrors["$index.language_id"] = 'Same language distorted with the same Nationality.';
                } else {
                    $combinations[] = $key;
                }
            }
        }
        $validator = Validator::make(array_merge($data, ['nationality_id' => $id]), $rules);
        $validator->after(function ($validator) use ($customErrors) {
            foreach ($customErrors as $field => $message) {
                $validator->errors()->add($field, $message);
            }
        });
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->nationalityTranslation->save($data, $id);
    }

    public function get($id)
    {
        return $this->nationalityTranslation->get($id);
    }

    public function del($id)
    {
        $rules = [
            'id' => 'required|integer|exists:nationality_translation,id',
        ];
        $validator = \Validator::make(['id' => $id], $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->nationalityTranslation->del($id);
    }
}
