<?php

namespace App\Events;

use App\Models\User;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class GroupNotificationEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public function __construct(
        public string $title,
        public string $message,
        public string $type,
        public ?string $modelName,
        public ?int $modelId,
        public ?int $senderBy,
        public array $data,
        public int $groupId
    ) {}

    /**
     * Get the channels the event should broadcast on.
     * Group channel: group.{groupId}
     */
    public function broadcastOn(): array
    {
        return [new PrivateChannel('group.'.$this->groupId)];
    }

    /**
     * The event's broadcast name.
     */
    public function broadcastAs(): string
    {
        return 'notification';
    }

    /**
     * Get the data to broadcast.
     */
    public function broadcastWith(): array
    {
        $senderName = null;
        $messageWithSender = $this->message;

        if ($this->senderBy) {
            $sender = User::find($this->senderBy);
            $senderName = $sender?->name;

            // إضافة اسم المرسل في رسالة الـ push
            if ($senderName) {
                $messageWithSender = "{$senderName}: {$this->message}";
            }
        }

        return [
            'title' => $this->title,
            'message' => $messageWithSender,
            'type' => $this->type,
            'model_name' => $this->modelName,
            'model_id' => $this->modelId,
            'sender_by' => $this->senderBy,
            'sender_name' => $senderName,
            'data' => $this->data,
        ];
    }
}
