<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class CountryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->relationLoaded('currentTranslation')
                ? ($this->currentTranslation->name ?? $this->name)
                : $this->name,
            'code' => $this->code,
            'active' => $this->is_active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
        ];
    }
}
