<?php

namespace App\Http\Resources\General;

use Illuminate\Http\Resources\Json\JsonResource;

class CompanyHistoryResource extends JsonResource
{
    public function toArray($request)
    {
        $data = [
            'audit_id' => $this['audit_id'],
            'user_id' => $this['user_id'],
            'user' => $this['user'],
            'old_values' => $this['old_values'],
            'new_values' => $this['new_values'],
            'changed_at' => $this['changed_at'] ? $this['changed_at']->format('Y-m-d H:i:s') : null,
            'event' => $this['event'],
            'ip_address' => $this['ip_address'],
            'user_agent' => $this['user_agent'],
            'audit_type' => $this['audit_type'] ?? 'company',
        ];

        // Add accounting_mapping_id if it's an accounting mapping audit
        if (isset($this['accounting_mapping_id'])) {
            $data['accounting_mapping_id'] = $this['accounting_mapping_id'];
        }

        return $data;
    }
}
