<?php

namespace App\Http\Resources\General;

use App\sys\Enums\Settings as SettingsEnum;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SettingsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // في صفحة index نعرض القيمة كما هي بدون علاقات
        $shouldExpand = $request->routeIs('general.settings.show');
        $value = $this->value;

        // معالجة خاصة فقط في show/{key}
        if ($shouldExpand && $this->key === SettingsEnum::DEFAULT_CURRENCY->value) {
            $currencyId = is_numeric($value) ? (int) $value : null;
            if ($currencyId) {
                $currency = \App\Models\General\Currency::with('currentTranslation')->find($currencyId);
                if ($currency) {
                    $value = [
                        'id' => $currency->id,
                        'name' => $currency->relationLoaded('currentTranslation') && $currency->currentTranslation
                            ? ($currency->currentTranslation->name ?? $currency->name)
                            : $currency->name,
                        'code' => $currency->code,
                        'symbol' => $currency->symbol,
                        'exchange_rate' => $currency->exchange_rate,
                        'is_default' => (bool) $currency->is_default,
                    ];
                }
            }
        }

        // معالجة خاصّة للـ banks (فقط في show/{key})
        if ($shouldExpand && $this->key === SettingsEnum::BANKS->value) {
            // دعم أكثر من شكل للتخزين: JSON Array أو نص مفصول بفواصل
            $treeAccountIds = is_array($value) ? $value : json_decode($value, true);
            if (! is_array($treeAccountIds)) {
                $treeAccountIds = collect(explode(',', (string) $value))
                    ->map(fn ($v) => (int) trim($v))
                    ->filter()
                    ->values()
                    ->all();
            }

            $treeAccounts = \App\Models\Accounting\TreeAccounting::whereIn('id', $treeAccountIds)
                ->with('currentTranslation')
                ->get();

            $value = $treeAccounts->map(function ($account) {
                return [
                    'id' => $account->id,
                    'name' => $account->relationLoaded('currentTranslation') && $account->currentTranslation
                        ? ($account->currentTranslation->title ?? $account->title)
                        : $account->title,
                ];
            })->values();
        }

        return [
            'id' => $this->id,
            'key' => $this->key,
            'value' => $value,
        ];
    }
}
