<?php

namespace App\Http\Resources\General\TaxRate;

use Illuminate\Http\Resources\Json\JsonResource;

class TaxRateLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->title,
            'percentage' => $this->percentage,
            'type' => $this->type,
            'active' => $this->is_active,
            'created_at' => $this->created,
            'updated_at' => $this->modified,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? TaxRateTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
