<?php

namespace App\Http\Resources\General\Translation;

use Illuminate\Http\Resources\Json\ResourceCollection;

class TranslationCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'data' => $this->collection->groupBy('controller_name')->map(function ($items, $controllerName) {
                return [
                    'controller_name' => $controllerName,
                    'translations' => TranslationResource::collection($items),
                ];
            })->values(),
        ];
    }
}
