<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class UserAccountMappingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'percentage' => $this->percentage,
            'currency_id' => $this->currency_id,
            'commission_account_id' => $this->commission_account_id,
            'wallet_account_id' => $this->wallet_account_id,
            'Supplier_account_id' => $this->Supplier_account_id,
            'currency' => $this->whenLoaded('currency', function () {

                return $this->currency ? [
                    'id' => $this->currency->id,
                    'name' => $this->currency->name,
                    'symbol' => $this->currency->symbol, // (افترضت وجود هذه الأعمدة)
                ] : null;
            }),

            'commission_account' => $this->whenLoaded('commissionAccount', function () {

                return $this->commissionAccount ? [
                    'id' => $this->commissionAccount->id,
                    'title' => $this->commissionAccount->title,
                    'serial_number' => $this->commissionAccount->serial_number,
                ] : null;
            }),
            'wallet_account' => $this->whenLoaded('walletAccount', function () {
                // $this->walletAccount هو موديل TreeAccounting
                return $this->walletAccount ? [
                    'id' => $this->walletAccount->id,
                    'title' => $this->walletAccount->title,
                    'serial_number' => $this->commissionAccount->serial_number,

                ] : null;
            }),

            'supplier_account' => $this->whenLoaded('supplierAccount', function () {
                // $this->supplierAccount هو موديل TreeAccounting
                return $this->supplierAccount ? [
                    'id' => $this->supplierAccount->id,
                    'title' => $this->supplierAccount->title,
                    'serial_number' => $this->supplierAccount->serial_number,

                ] : null;
            }),

        ];
    }
}
