<?php

namespace App\Models\Accounting;

use App\Models\General\Companies;
use App\Models\General\Currency;
use Illuminate\Database\Eloquent\Model;

class TreeAccounting extends Model
{
    protected $table = 'tree_accounting';

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function company()
    {
        return $this->belongsTo(Companies::class, 'company_id');
    }

    public function parent()
    {
        return $this->belongsTo(self::class, 'tree_accounting_id');
    }

    public function structure()
    {
        return $this->belongsTo(AccountsStructure::class, 'accounts_structure_id');
    }

    public function children()
    {
        return $this->hasMany(self::class, 'tree_accounting_id');
    }

    public function getAllChildren()
    {
        return $this->hasMany(self::class, 'tree_accounting_id')->with('getAllChildren');
    }

    public function getAllChildrenIdsFromRelationship()
    {
        $ids = [];

        $this->loadMissing('getAllChildren');

        foreach ($this->getAllChildren as $child) {
            $ids[] = $child->id;

            $ids = array_merge($ids, $child->getAllChildrenIdsFromRelationship());
        }

        return $ids;
    }

    public function translations()
    {
        return $this->hasMany(TreeAccountingTranslation::class, 'tree_accounting_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(TreeAccountingTranslation::class, 'tree_accounting_id')
            ->where('lang_id', request('lang_id'));
    }

    public function transfers()
    {
        return $this->hasMany(Transfer::class, 'tree_accounting_id');
    }

    public function settings()
    {
        return $this->hasOne(TreeAccountSetting::class, 'tree_account_id', 'id');
    }
}
