<?php

namespace App\Models\General;

use App\Models\Suppliers\Suppliers;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class Domain extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $table = 'domains';

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    protected $fillable = [
        'title',
        'tax_rate_id',
        'type',
        'enabled_disable',
    ];

    protected $casts = [
        'enabled_disable' => 'boolean',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'title',
        'tax_rate_id',
        'type',
        'enabled_disable',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
        'deleted_at',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function taxRate()
    {
        return $this->belongsTo(TaxRate::class, 'tax_rate_id');
    }

    public function translations()
    {
        return $this->hasMany(DomainTranslation::class, 'domain_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(DomainTranslation::class, 'domain_id')
            ->where('lang_id', app('lang_id'));
    }

    public function suppliers()
    {
        return $this->belongsToMany(Suppliers::class, 'supplier_domain', 'domain_id', 'supplier_id');
    }
}
