<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class TransportationModes extends Model implements Auditable
{
    use AuditableTrait, SoftDeletes;

    protected $table = 'ge_transportation_modes';

    protected $fillable = [
        'name',
        'is_active',
    ];

    protected $auditInclude = [
        'name',
        'is_active',
    ];

    protected $auditExclude = [
        'created_at',
        'updated_at',
    ];

    protected $auditEvents = [
        'updated',
    ];

    public function translations()
    {
        return $this->hasMany(TransportationModesTranslation::class, 'tranortation_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(TransportationModesTranslation::class, 'tranortation_id')
            ->where('lang_id', app('lang_id'));
    }
}
