<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class TransportationReason extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $table = 'ge_transportation_reason';

    protected $fillable = [
        'name',
        'is_active',
    ];

    protected $auditInclude = [
        'name',
        'is_active',
    ];

    protected $auditExclude = [
        'created_at',
        'updated_at',
    ];

    protected $auditEvents = [
        'updated',
    ];

    public function translations()
    {
        return $this->hasMany(TransportationReasonTranslation::class, 'transportation_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(TransportationReasonTranslation::class, 'transportation_id')
            ->where('lang_id', app('lang_id'));
    }
}
